﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;
using VeteransAffairs.Registries.BusinessAHOBPR.PaymentService;
using VeteransAffairs.Registries.BusinessAHOBPR;

namespace WCF_BusinessManagerAHOBPRTests.EMIS
{
    [TestClass]
    public class PaymentHistoryManagerTests
    {
        PaymentHistoryManager _cut;

        [TestInitialize()]
        public void MyTestInitialize()
        {
            _cut = new PaymentHistoryManager("Data Source = DNS; Initial Catalog = Registry_AHOBPRHRE; Integrated Security = True; Encrypt = yes");
        }
        [TestMethod]
        public void GetRegistrantHistory_Throws_Exception_When_Given_Non_Numerals_For_Edipi()
        {
            AssertException.Throws<ArgumentException>(() => _cut.GetRegistrantHistory("xxxxxxxxxxxx"));
        }
        [TestMethod]
        public void GetRegistrantHistory_Throws_Exception_When_Given_Edipi_With_Less_Than_Ten_Digits()
        {
            AssertException.Throws<ArgumentException>(() => _cut.GetRegistrantHistory("123456789"));
        }
        [TestMethod]
        public void GetRegistrantHistory_Throws_Exception_When_Given_Edipi_With_More_Than_Ten_Digits()
        {
            AssertException.Throws<ArgumentException>(() => _cut.GetRegistrantHistory("123456789012"));
        }
        [TestMethod]
        public void GetRegistrantHistory_Returns_Correct_Number_Of_PayGrade_Entries()
        {
            //User 6001010001 has TWO paygrade history entries in EMIS
            var actual = _cut.GetRegistrantHistory("6001010001");
            Assert.AreEqual(2, actual.Keys.Count);
        }
        [TestMethod]
        public void LookupPayPlan_ReturnsObjectFromDB()
        {
            string branchOfServiceCode = "A";
            PayGradeHistoryData payGrade = new PayGradeHistoryData
            {
                PayGradeCode = "05",
                payPlanCode = "ME",
                serviceRankNameCode = "SGT",
                serviceRankNameTxt = "Sergeant"
            };
            var expectedPayPlan = new STD_PAYPLAN
            {
                SERVICE_CODE = "A",
                PAY_PLAN_CODE_SHORT = "ME",
                PAYGRADE_CODE = "05",
                RANK_CODE = "SGT",
                RANK_TEXT = "Sergeant"
            };
            var actual = _cut.LookupPayPlan(payGrade, branchOfServiceCode);
            Assert.AreEqual(expectedPayPlan.SERVICE_CODE, branchOfServiceCode);
            Assert.AreEqual(expectedPayPlan.PAY_PLAN_CODE_SHORT, "ME");
            Assert.AreEqual(expectedPayPlan.PAYGRADE_CODE, "05");
            Assert.AreEqual(expectedPayPlan.RANK_CODE, "SGT");
            Assert.AreEqual(expectedPayPlan.RANK_TEXT, "Sergeant");
            Assert.AreEqual( 89, actual.STD_PAYPLAN_ID);
        }

        [TestMethod]
        public void LookupPayPlan_Returns_Correct_Rank_For_TimePeriod()
        {
            string branchOfServiceCode = "A";
            PayGradeHistoryData payGrade = new PayGradeHistoryData
            {
                PayGradeCode = "04",
                payPlanCode = "MO",
                serviceRankNameCode = "MAJ",
                serviceRankNameTxt = "Major"
            };
            var expectedPayPlan = new STD_PAYPLAN
            {
                SERVICE_CODE = "A",
                PAY_PLAN_CODE_SHORT = "MO",
                PAYGRADE_CODE = "04",
                RANK_CODE = "MAJ",
                RANK_TEXT = "Major"
            };
            var actual = _cut.LookupPayPlan(payGrade, branchOfServiceCode);
            Assert.AreEqual(expectedPayPlan.SERVICE_CODE, branchOfServiceCode);
            Assert.AreEqual(expectedPayPlan.PAY_PLAN_CODE_SHORT, "MO");
            Assert.AreEqual(expectedPayPlan.PAYGRADE_CODE, "04");
            Assert.AreEqual(expectedPayPlan.RANK_CODE, "MAJ");
            Assert.AreEqual(expectedPayPlan.RANK_TEXT, "Major");
            Assert.AreEqual(104, actual.STD_PAYPLAN_ID);
        }
        [TestMethod]
        public void LookupPayPlan_Returns_Null_If_No_Matching_PayPlan_In_DB()
        {
            string branchOfServiceCode = "A";
            PayGradeHistoryData payGrade = new PayGradeHistoryData
            {
                PayGradeCode = "05",
                payPlanCode = "ME",
                serviceRankNameCode = "SSGT",
                serviceRankNameTxt = "Sergeant"
            };
            var expectedPayPlan = new STD_PAYPLAN
            {
                SERVICE_CODE = "A",
                PAY_PLAN_CODE_SHORT = "ME",
                PAYGRADE_CODE = "05",
                RANK_CODE = "SGT",
                RANK_TEXT = "Sergeant"
            };
            var actual = _cut.LookupPayPlan(payGrade, branchOfServiceCode);
            Assert.IsNull(actual);
        }
       // [TestMethod]
        //public void IsMatch_Returns_True_On_Match()
        //{
        //    string branchOfServiceCode = "A";
        //    PayGradeHistoryData payGrade = new PayGradeHistoryData
        //    {
        //        PayGradeCode = "05",
        //        payPlanCode = "ME",
        //        serviceRankNameCode = "SGT",
        //        serviceRankNameTxt = "Sergeant"
        //    };
        //    var dbPayPlan = new STD_PAYPLAN
        //    {
        //        SERVICE_CODE = "A",
        //        PAY_PLAN_CODE_SHORT = "ME",
        //        PAYGRADE_CODE = "05",
        //        RANK_CODE = "SGT",
        //        RANK_TEXT = "Sergeant"
        //    };
        //    var actual = _cut.IsMatch(dbPayPlan, payGrade, branchOfServiceCode);
        //    Assert.AreEqual(true, actual);
        //}
        //[TestMethod]
        //public void IsMatch_Returns_True_Even_If_Comparing_Differing_UpperLowerCased_Properties()
        //{
        //    string branchOfServiceCode = "A";
        //    PayGradeHistoryData payGrade = new PayGradeHistoryData
        //    {
        //        PayGradeCode = "05",
        //        payPlanCode = "me",
        //        serviceRankNameCode = "sgt",
        //        serviceRankNameTxt = "SERGEANT"
        //    };
        //    var dbPayPlan = new STD_PAYPLAN
        //    {
        //        SERVICE_CODE = "A",
        //        PAY_PLAN_CODE_SHORT = "ME",
        //        PAYGRADE_CODE = "05",
        //        RANK_CODE = "SGT",
        //        RANK_TEXT = "Sergeant"
        //    };
        //    var actual = _cut.IsMatch(dbPayPlan, payGrade, branchOfServiceCode);
        //    Assert.AreEqual(true, actual);
        //}

    }
}
